/**
 *
 */
package gov.va.med.mhv.usermgmt.service;

import gov.va.med.mhv.common.api.dto.FacilityInfoDTO;
import gov.va.med.mhv.common.api.dto.InPersonAuthenticationDTO;
import gov.va.med.mhv.common.api.dto.InPersonAuthenticationDTOLight;
import gov.va.med.mhv.common.api.dto.PatientDTO;
import gov.va.med.mhv.common.api.dto.PatientWithDelegatesDTO;
import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.usermgmt.common.dto.A24PatientLinkTO;
import gov.va.med.mhv.usermgmt.common.dto.A31PersonalInfoUpdateTO;
import gov.va.med.mhv.usermgmt.common.dto.A43PatientMoveTO;
import gov.va.med.mhv.usermgmt.common.dto.ActivityDTO;
import gov.va.med.mhv.usermgmt.common.dto.FieldTestDTO;

import java.util.Date;
import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.springframework.stereotype.Service;

/**
 * @author DNS
 *
 * The point of this service is to provide a method to clients that does not
 * require authentication but that can provide an answer as to whether the
 * username provided as a parameter to the isUserActive method refers to a user
 * that is an active MHV end user.
 *
 */
@Path("/")
@Service("accountValidatorService")
public interface AccountValidatorService {

	/**
	 * Returns true if the user is an active MHV user; otherwise false.
	 * @param userName The username of the user whose account status is in question.
	 * @return True if the user is active; otherwise false.
	 * @throws MHVException In the event that an exception occurs.
	 */
	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/isinactive/{userName}")
	public Boolean isUserInactive(@PathParam("userName") String userName) throws MHVException;

	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/findUserNameByHash/{ahash:.+}") 
	String findUserNameByHash(@PathParam("ahash") String ahash);

	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/findUserProfileByusername/{username}")
	UserProfileDTO findUserProfileByusername(@PathParam("username") String username) throws MHVException;

	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/findUserProfileById/{id}")
	UserProfileDTO findUserProfileById(@PathParam("id") Long id);

	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/getPatientForUser/{userProfileId}")
	PatientDTO getPatientForUser(@PathParam("userProfileId") Long userProfileId);

	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/getPatientById/{patientId}")
	PatientDTO getPatientById(@PathParam("patientId") Long patientId);
	
	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/searchPersonInMVIByICN/{icn}")
	PatientDTO searchPersonInMVIByICN(@PathParam("icn") String icn) throws MHVException;

	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/getPatientByIcn/{icn}")
	PatientDTO getPatientByIcn(@PathParam("icn") String icn) throws MHVException;

	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/searchPersonInMVIForDSLogonn/{edipiValue}")
	PatientDTO searchPersonInMVIForDSLogon(@PathParam("edipiValue") String edipiValue) throws MHVException;

	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/searchPersonInMVIForUSAA/{fName}/{mName}/{lName}/{dob}/{gender}/{ssn}")
	PatientDTO searchPersonInMVIForUSAA(@PathParam("fName") String fName, @PathParam("mName") String mName,
		@PathParam("lName") String lName, @PathParam("dob") String dob, @PathParam("gender") String gender, @PathParam("ssn") String ssn)
		throws MHVException;

	@POST
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/matchPerson/{userProfileId}")
	PatientDTO matchPerson(@PathParam("userProfileId") Long userProfileId) throws MHVException;

	@POST
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/matchPerson/{userProfileId}")
	PatientDTO addPersonForCorrelation(@PathParam("userProfileId") Long userProfileId) throws MHVException;

	@POST
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/patientMoveNotification")
	public Response patientMoveNotification(A43PatientMoveTO a43PatientMoveTO);
	
	@POST
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/patientLinkNotification")
	public Response patientLinkNotification(A24PatientLinkTO a24PatientLinkTO);
	
	@POST
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/personalNotification")
	public Response personalNotification(A31PersonalInfoUpdateTO a31PesonalInfoUpdateTO);
	
	@POST
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/removeCorrelation/{userProfileId}")
	PatientDTO removeCorrelation(@PathParam("userProfileId") Long userProfileId) throws MHVException;

	@POST
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/updateTreatmentFacilitiesForExistingPatients/{userProfileId}")
	PatientDTO updateTreatmentFacilitiesForExistingPatients(@PathParam("userProfileId") Long userProfileId) throws MHVException;

	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/processLastLogin/{userProfileId}/{csid}")
	void processLastLogin(@PathParam("userProfileId") Long userProfileId, @PathParam("csid")String csid);

	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/getUserProfileForVAAFITraits/{firstName}/{lastName}/{gender}/{dob:.+}")
	UserProfileDTO getUserProfileForVAAFITraits(@PathParam("firstName") String firstName, @PathParam("lastName") String lastName, @PathParam("dob") String dob, @PathParam("gender") String gender) throws MHVException;

	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/getAuthenticationForPatient/{patientId}")
	InPersonAuthenticationDTOLight getAuthenticationForPatient(@PathParam("patientId")Long patientId) throws MHVException;

	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/getAustinMHVFacilityInfo")
	FacilityInfoDTO getAustinMHVFacilityInfo() throws MHVException;

	@POST
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	@Path("/saveIPA")
	InPersonAuthenticationDTOLight saveIPA(InPersonAuthenticationDTOLight ipaDTO) throws MHVException;

	@POST
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	@Path("/auditOnlineAuthenticationEvent/{subjectId}/{successful}/{activityName}/{actionName}/{detail}")
	void auditOnlineAuthenticationEvent(@PathParam("subjectId") Long subjectId, @PathParam("successful")Boolean successful, @PathParam("activityName")String activityName,
		@PathParam("actionName")String actionName, @PathParam("detail")String detail);

	@POST
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	@Path("/auditOnlineAuthenticationEvent/{subjectId}")
	void auditOnlineAuthenticationEvent2(@PathParam("subjectId") Long subjectId);

	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	@Path("/getVapiiFormStatusForUser/{userProfileId}")
	String getVapiiFormStatusForUser(@PathParam("userProfileId")Long userProfileId) throws MHVException;

	@POST
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	@Path("/auditDSLogonMappingEvent/{subjectId}/{successful}/{actor}/{activityType}/{actionType}")
	void auditDSLogonMappingEvent(@PathParam("subjectId") Long subjectId, @PathParam("successful") Boolean successful, @PathParam("actor") String actor,
		@PathParam("activityType") String activityType, @PathParam("actionType") String actionType);
	
	@POST
	@Path("/createAccountActivityLog")
	@Consumes(MediaType.APPLICATION_JSON)
	public void createAccountActivityLog(ActivityDTO activity)  throws MHVException;
	
	@POST
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	@Path("/auditDSLogonActivity/{userProfileId}/{successful}/{actor}/{actionType}/{activityDetailValue}")
	void auditDSLogonMappingActivity(@PathParam("userProfileId") Long userProfileId, @PathParam("successful") Boolean successful, @PathParam("actor") String actor,
		@PathParam("actionType") String actionType, @PathParam("activityDetailValue") String activityDetailValue);


	@POST
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	@Path("/saveHash/{userProfileId}/{ahash:.+}")
	void saveHash(@PathParam("userProfileId") Long userProfileId, @PathParam("ahash") String ahash);

//	@POST
//	@Produces(MediaType.APPLICATION_JSON)
//	@Consumes(MediaType.APPLICATION_JSON)
//	@Path("/saveHashByUserName/{userName}/{ahash}")
//	void saveHash(@PathParam("userName") String userName, @PathParam("ahash") String ahash);

//	@POST
//	@Produces(MediaType.APPLICATION_JSON)
//	@Consumes(MediaType.APPLICATION_JSON)
//	@Path("/ipaAuthenticateFull")
//	InPersonAuthenticationDTO ipaAuthenticateFull(InPersonAuthenticationDTO ipaDTO) throws MHVException;
	
	@POST
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	@Path("/saveIPAFull")
	InPersonAuthenticationDTO saveIPAFull(InPersonAuthenticationDTO ipaDTOFull) throws MHVException;

	@POST
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	@Path("/authenticateOnline")
	InPersonAuthenticationDTOLight authenticateOnline(InPersonAuthenticationDTOLight ipaDTO) throws MHVException;


	@POST
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	@Path("/ipaAuthenticate")
	InPersonAuthenticationDTOLight ipaAuthenticate(InPersonAuthenticationDTOLight ipaDTO) throws MHVException;

	@POST
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	@Path("/auditUpgradeEvent/{subjectId}/{actor}/{actionType}/{activityDetailValue}")
	void auditUpgradeEvent(@PathParam("subjectId") Long subjectId, @PathParam("actor") String actor, @PathParam("actionType") String actionType,
		@PathParam("activityDetailValue") String activityDetailValue);

	@POST
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	@Path("/deferAuthentication")
	InPersonAuthenticationDTOLight deferAuthentication(InPersonAuthenticationDTOLight ipaDTO) throws MHVException;

	@POST
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	@Path("/auditManualAuthenticationEvent/{subjectId}/{successful}/{activityName}/{detail}")
	void auditManualAuthenticationEvent(@PathParam("subjectId") Long subjectId, @PathParam("successful") Boolean successful,
		@PathParam("activityName") String actionName, @PathParam("detail") String detail);

	@POST
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	@Path("/checkPassowrd")
	boolean checkPassowrd(UserProfileDTO userProfileDTO);

	@POST
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	@Path("/saveUserProfile")
	UserProfileDTO saveUserProfile(UserProfileDTO userProfileDTO) throws MHVException;

	@POST
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	@Path("/auditMviEvent/{subjectId}/{actor}/{successful}/{activityActionType}/{activityType}")
	void auditMviEvent(@PathParam("subjectId") Long subjectId, @PathParam("actor") String actor, @PathParam("successful") Boolean successful,
		@PathParam("activityActionType") String activityActionType, @PathParam("activityType") String activityType);

	@POST
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	@Path("/logEauthEvent/{userName}/{csid}/{event}/{ahash:.+}")
	void logEauthEvent(@PathParam("ahash")String ahash, @PathParam("userName")String userName, @PathParam("csid")String csid, @PathParam("event")String event);

	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	@Path("/getVapiiFormUrl")
	String getVapiiFormUrl();

	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	@Path("/getSreAutoLoginUrl")
	String getSreAutoLoginUrl();


	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	@Path("/getSreAnonymousUrl")
	String getSreAnonymousUrl();

	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/userprofiledobav")
	public UserProfileDTO getUserProfile(@QueryParam("firstName") String firstName, @QueryParam("lastName") String lastName, @QueryParam("gender") String gender, @QueryParam("birthDate")Date birthDate) throws MHVException;

	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/userprofilescount")
	public Long getUserProfilesCount(@QueryParam("firstName") String firstName, @QueryParam("lastName") String lastName, @QueryParam("gender") String gender, @QueryParam("birthDate")Date birthDate) throws MHVException;

	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/userprofileforusername")
	public UserProfileDTO getUserProfileForUserName(@QueryParam("firstName") String firstName, @QueryParam("lastName") String lastName, @QueryParam("userName") String userName, @QueryParam("gender") String gender, @QueryParam("birthDate")Date birthDate) throws MHVException;

	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/userprofilebynamessn")
	public List<UserProfileDTO> getUserProfileByNameSSN(@QueryParam("firstName") String firstName, @QueryParam("lastName") String lastName, @QueryParam("gender") String gender, @QueryParam("birthDate")Date birthDate, @QueryParam("ssn")String ssn) throws MHVException;

	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/userprofilebynamessncount")
	public Long getUserProfileByNameSSNCount(@QueryParam("firstName") String firstName, @QueryParam("lastName") String lastName, @QueryParam("gender") String gender, @QueryParam("birthDate")Date birthDate, @QueryParam("ssn")String ssn) throws MHVException;

	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/userprofilebynameemail")
	public List<UserProfileDTO> getUserProfileByNameEmail(@QueryParam("firstName") String firstName, @QueryParam("lastName") String lastName, @QueryParam("gender") String gender, @QueryParam("birthDate")Date birthDate, @QueryParam("email")String email) throws MHVException;

	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/userprofilebynameemailcount")
	public Long getUserProfileByNameEmailCount(@QueryParam("firstName") String firstName, @QueryParam("lastName") String lastName, @QueryParam("gender") String gender, @QueryParam("birthDate")Date birthDate, @QueryParam("email")String email) throws MHVException;

	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/userprofilebynamephone")
	public List<UserProfileDTO> getUserProfileByNamePhone(@QueryParam("firstName") String firstName, @QueryParam("lastName") String lastName, @QueryParam("gender") String gender, @QueryParam("birthDate")Date birthDate, @QueryParam("phone")String phone) throws MHVException;

	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/userprofilebynamephonecount")
	public Long getUserProfileByNamePhoneCount(@QueryParam("firstName") String firstName, @QueryParam("lastName") String lastName, @QueryParam("gender") String gender, @QueryParam("birthDate")Date birthDate, @QueryParam("phone")String phone) throws MHVException;

	@POST
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/changepasswordav/{isForgotPwd}")
	public UserProfileDTO changePassword(UserProfileDTO userProfileJSON, @PathParam("isForgotPwd")Boolean isForgotPwd) throws MHVException;

	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/validatehintanswers")
	public Boolean validateHintAnswers(@QueryParam("userId") Long userId, @QueryParam("answer1") String answer1, @QueryParam("answer2") String answer2) throws MHVException;
	
	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/retrievePersonInMVIForDSLogon/{edipiValue}")
	PatientWithDelegatesDTO retrievePersonInMVIForDSLogon(@PathParam("edipiValue") String edipiValue) throws MHVException;

	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/fieldTestGroups/{userName}")
	public List<FieldTestDTO> getFieldTestGroupsByUserName(@PathParam("userName") String userName) throws MHVException;

}
